close all
clear all

addpath(genpath('S:\AG Wegener\MechaMeta\Youngsmodulus Tuning Fork\Messung\Functions'))
addpath(genpath('S:\AG Wegener\MechaMeta\Youngsmodulus Tuning Fork\Messung\Functions\exportfig'))



measurement1 = 'result_amplitude_side.dat';
measurement2 = 'result_amplitude_top.dat';
measurement3 = 'result_frequency.dat';
measurement4 = 'result_phase_angle.dat';

filename1 = measurement1;
filename2 = measurement2;
filename3 = measurement3;
filename4 = measurement4;



result_amplitude_side = importdata(filename1);
result_amplitude_top = importdata(filename2);
result_frequency = importdata(filename3);
phase_angle_result = importdata(filename4);
%guess for the maximum of the frequency
guess_maximum=result_frequency(find(result_amplitude_side==max(result_amplitude_side)));

figure;
double_result_amplitude=result_amplitude_side.*result_amplitude_side;
double_result_amplitude_side=double_result_amplitude;
plot(result_frequency(:),result_amplitude_side(:),'.')
xlabel('frequency in kHz')
ylabel('Maximum displacement in units of the excitation amplitude')
legend('datapoint')
title('Resonance Plot sideview')
plot_counter=1;
automate_evaluation_fit
savefig('sideview_amplitude_result');
export_fig sideview_amplitude_result;


figure;
double_result_amplitude=result_amplitude_top.*result_amplitude_top;
double_result_amplitude_top=double_result_amplitude;
plot(result_frequency(:),result_amplitude_top(:),'.')
xlabel('frequency in kHz')
ylabel('Maximum displacement in units of the excitation amplitude')
legend('datapoint')
title('Resonance Plot topview')
plot_counter=2;
automate_evaluation_fit
savefig('topview_amplitude_result');
export_fig topview_amplitude_result;

for p=1:length(phase_angle_result_top)
    phase_angle_result(p)=-phase_angle_result_top(p)+phase_angle_result_bottom(p);
    if phase_angle_result(p)<0
        phase_angle_result(p)=2+phase_angle_result(p);
    end
end

% for p=1:length(phase_angle_result_top)
%     if phase_angle_result_top(p)<phase_angle_result_bottom(p)
%     phase_angle_result(p)=2+phase_angle_result_top(p)-phase_angle_result_bottom(p);
%
%     else
%     phase_angle_result(p)=phase_angle_result_top(p)-phase_angle_result_bottom(p);
%     end
% end

figure;
title('Phase angle')
plot(result_frequency(:),phase_angle_result(:),'.')
ylabel('Phase angle in units of \pi')
xlabel('frequency in kHz')
automate_evaluation_fit_2
[filepath,name,ext]=fileparts(pwd);
savefig('phase_angle_result');
export_fig phase_angle_result;

%average of side and topview

figure;
double_result_amplitude=(double_result_amplitude_side+double_result_amplitude_top)/2;
plot(result_frequency(:),result_amplitude_top(:),'.')
xlabel('frequency in kHz')
ylabel('Maximum displacement in units of the excitation amplitude')
legend('datapoint')
title('Resonance Plot topview')
plot_counter=3;
automate_evaluation_fit
savefig('result_amplitude_mean');
export_fig result_amplitude_mean;
